﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseData_UzupelnianieLukII : GExerciseData
    {
        public class ExerciseDataStub : IExerciseDataStub
        {
            public ExerciseDataStub()
            {
                options = new List<List<string>>();
                correct = new List<int>();
                answers = new List<int>();
            }

            public int id { get; set; }
            public string text { get; set; }
            public List<List<string>> options { get; set; }
            public List<int> correct { get; set; }
            public List<int> answers { get; set; }
        }

        private List<ExerciseDataStub> _listStub = null;

        public List<ExerciseDataStub> ExerciseData
        {
            get
            {
                if (_listStub == null)
                {
                    _listStub = new List<ExerciseDataStub>();
                }

                return _listStub;
            }
        }

        public GExerciseData_UzupelnianieLukII(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam)
            : base(BLP, ContextParam)
        {
            
        }

        public void Load()
        {
            if (ContextParam.ExerciseOut != null)
            {
                switch (ContextParam.ExerciseOut.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.ComboBox_Section: ComboBox_SectionLoad(ContextParam.ExerciseOut); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.ComboBox_Text: ComboBox_TextLoad(ContextParam.ExerciseOut); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_ComboBox: Questions_ComboBoxLoad(ContextParam.ExerciseOut); break;
                }
            }
        }

        public void Check(List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            if (ContextParam.ExerciseIn != null)
            {
                switch (ContextParam.ExerciseIn.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.ComboBox_Section: ComboBox_SectionCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.ComboBox_Text: ComboBox_TextCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_ComboBox: Questions_ComboBoxCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                }

                SetExerciseOwlSave();
            }
        }

        private void ComboBox_SectionLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 0;
            XmlNode _xmlSections = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Sections);
            XmlNodeList _listXmlSection = _xmlSections.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Section);


            foreach (XmlNode _loopXmlSection in _listXmlSection)
            {
                _stubIndex++;

                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.options = new List<List<string>>();
                _loopStub.correct = new List<int>();

                StringBuilder _sbText = new StringBuilder();

                foreach (XmlNode _loopXml in _loopXmlSection.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text)
                    {
                        _sbText.Append(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                    }

                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        _sbText.Append(Dictionary.OPEN_GAP);

                        Dictionary<int, PI.GM.N610.ELearning.BL.Dictionary.Exercise.BoxValue> _loopInputValueDictionary = BLP.BLELearning.Utility.ValueDictionary(_loopXml);

                        List<string> _loopOptionsList = new List<string>();
                        bool _addCorrectIndex = false;
                        int _valueDictionaryIndex = 1;
                        foreach (KeyValuePair<int, PI.GM.N610.ELearning.BL.Dictionary.Exercise.BoxValue> _loopValueDictionary in _loopInputValueDictionary)
                        {
                            if(_loopValueDictionary.Value.IsAnsverCorrect == true && _addCorrectIndex == false)
                            {
                                _addCorrectIndex = true;
                                _loopStub.correct.Add(_valueDictionaryIndex);
                            }

                            _loopOptionsList.Add(_loopValueDictionary.Value.Text);

                            _valueDictionaryIndex++;
                        }

                        _loopStub.options.Add(_loopOptionsList);
                    }
                }

                _loopStub.text = _sbText.ToString();

                ExerciseData.Add(_loopStub);
            }
        }

        private void ComboBox_TextLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 1;
            XmlNode _xmlText = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text);

                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.options = new List<List<string>>();
                _loopStub.correct = new List<int>();

                StringBuilder _sbText = new StringBuilder();

                foreach (XmlNode _loopXml in _xmlText.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text)
                    {
                        _sbText.Append(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                    }

                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        _sbText.Append(Dictionary.OPEN_GAP);

                        Dictionary<int, PI.GM.N610.ELearning.BL.Dictionary.Exercise.BoxValue> _loopInputValueDictionary = BLP.BLELearning.Utility.ValueDictionary(_loopXml);

                        List<string> _loopOptionsList = new List<string>();
                        bool _addCorrectIndex = false;
                        int _valueDictionaryIndex = 1;
                        foreach (KeyValuePair<int, PI.GM.N610.ELearning.BL.Dictionary.Exercise.BoxValue> _loopValueDictionary in _loopInputValueDictionary)
                        {
                            if (_loopValueDictionary.Value.IsAnsverCorrect == true && _addCorrectIndex == false)
                            {
                                _addCorrectIndex = true;
                                _loopStub.correct.Add(_valueDictionaryIndex);
                            }

                            _loopOptionsList.Add(_loopValueDictionary.Value.Text);

                            _valueDictionaryIndex++;
                        }

                        _loopStub.options.Add(_loopOptionsList);
                    }
                }

                _loopStub.text = _sbText.ToString();

                ExerciseData.Add(_loopStub);
        }

        private void Questions_ComboBoxLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 0;
            XmlNode _xmlSections = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Questions);
            XmlNodeList _listXmlSection = _xmlSections.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Question);


            foreach (XmlNode _loopXmlSection in _listXmlSection)
            {
                _stubIndex++;

                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.options = new List<List<string>>();
                _loopStub.correct = new List<int>();

                StringBuilder _sbText = new StringBuilder();

                foreach (XmlNode _loopXml in _loopXmlSection.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text)
                    {
                        _sbText.Append(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                    }

                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        _sbText.Append(Dictionary.OPEN_GAP);

                        Dictionary<int, PI.GM.N610.ELearning.BL.Dictionary.Exercise.BoxValue> _loopInputValueDictionary = BLP.BLELearning.Utility.ValueDictionary(_loopXml);

                        List<string> _loopOptionsList = new List<string>();
                        bool _addCorrectIndex = false;
                        int _valueDictionaryIndex = 1;
                        foreach (KeyValuePair<int, PI.GM.N610.ELearning.BL.Dictionary.Exercise.BoxValue> _loopValueDictionary in _loopInputValueDictionary)
                        {
                            if (_loopValueDictionary.Value.IsAnsverCorrect == true && _addCorrectIndex == false)
                            {
                                _addCorrectIndex = true;
                                _loopStub.correct.Add(_valueDictionaryIndex);
                            }

                            _loopOptionsList.Add(_loopValueDictionary.Value.Text);

                            _valueDictionaryIndex++;
                        }

                        _loopStub.options.Add(_loopOptionsList);
                    }
                }

                _loopStub.text = _sbText.ToString();

                ExerciseData.Add(_loopStub);
            }
        }


        private void ComboBox_SectionCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            int _stubIndex = 0;
            int _optionsCounter = 0;
            Exercise.TmpPoints = 0;

            XmlNode _xmlSections = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Sections);
            XmlNodeList _listXmlSection = _xmlSections.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Section);


            foreach (XmlNode _loopXmlSection in _listXmlSection)
            {
                _optionsCounter = 0;

                GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
                GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
                _loopExerciseCheck.id = _stubIndex++;
                foreach (XmlNode _loopXml in _loopXmlSection.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        if (BLP.BLELearning.Utility.IsAnswerCorrect(_loopExerciseDataSave.answers[_optionsCounter], BLP.BLELearning.Utility.ValueDictionary(_loopXml).Values))
                        {
                            Exercise.TmpPoints++;
                            _loopExerciseCheck.success_arr.Add(true);
                        }
                        else
                        {
                            _loopExerciseCheck.success_arr.Add(false);
                        }

                        _optionsCounter++;
                    }
                }

                ExerciseCheck.Add(_loopExerciseCheck);
                _stubIndex++;
            }
        }

        private void ComboBox_TextCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            int _stubIndex = 0;
            int _optionsCounter = 0;
            Exercise.TmpPoints = 0;

            XmlNode _xmlText = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text);

            GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
            GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
            _loopExerciseCheck.id = _stubIndex++;

            foreach (XmlNode _loopXml in _xmlText.ChildNodes)
            {
                if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                {
                    if (BLP.BLELearning.Utility.IsAnswerCorrect(_loopExerciseDataSave.answers[_optionsCounter], BLP.BLELearning.Utility.ValueDictionary(_loopXml).Values))
                    {
                        Exercise.TmpPoints++;
                        _loopExerciseCheck.success_arr.Add(true);
                    }
                    else
                    {
                        _loopExerciseCheck.success_arr.Add(false);
                    }

                    _optionsCounter++;
                }
            }

            ExerciseCheck.Add(_loopExerciseCheck);
        }

        private void Questions_ComboBoxCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            int _stubIndex = 0;
            int _optionsCounter = 0;
            Exercise.TmpPoints = 0;

            XmlNode _xmlQuestions = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Questions);
            XmlNodeList _listXmlQuestion = _xmlQuestions.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Question);

            foreach (XmlNode _loopXmlSection in _listXmlQuestion)
            {
                GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
                GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
                _loopExerciseCheck.id = _stubIndex+1;

                _optionsCounter = 0;

                foreach (XmlNode _loopXml in _loopXmlSection.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        if (BLP.BLELearning.Utility.IsAnswerCorrect(_loopExerciseDataSave.answers[_optionsCounter], BLP.BLELearning.Utility.ValueDictionary(_loopXml).Values))
                        {
                            Exercise.TmpPoints++;
                            _loopExerciseCheck.success_arr.Add(true);
                        }
                        else
                        {
                            _loopExerciseCheck.success_arr.Add(false);
                        }

                        _optionsCounter++;
                    }
                }

                ExerciseCheck.Add(_loopExerciseCheck);
                _stubIndex++;
            }
        }
    }
}
